import { View } from "react-native";
import React from "react";
import { productDetailsStyle } from "../../ProductDetails/ProductDetailsStyle";
import ItemPrice from "./ItemSection/ItemPrice";
import ItemStock from "./ItemSection/ItemStock";
import GroupProducts from "./ItemSection/ItemGroupProduct/GroupProducts";
import VariationOption from "./ItemSection/VariableProduct/VariationOption";

const ItemDetails = (props) => {
    const {
        price,
        productDetails,
        stockManage,
        setDisableBtn,
        disableBtn,
        inputData,
        setInputData,
        images,
    } = props;
    const {
        type,
        meta,
        stock_hide,
        group_products,
        name,
        featured_image = {},
        isEnableB2B,
        b2bData
    } = productDetails?.data;

    const b2b = {
        isEnableB2B,
        b2bData
    };
    return (
        <View style={productDetailsStyle.container}>
            <ItemPrice price={price} type={type} b2b={b2b} />
            {type === "Variable Product" && (
                <VariationOption
                    {...props}
                    meta={meta}
                    type={type}
                    images={images}
                    name={name}
                    featured_image={featured_image}
                />
            )}
            {type === "Grouped Product" &&
                group_products?.productDetails?.length > 0 &&
                group_products?.otherData?.length > 0 && (
                    <GroupProducts
                        groupProducts={group_products}
                        setDisableBtn={setDisableBtn}
                        inputData={inputData}
                        setInputData={setInputData}
                    />
                )}

            {type == "Simple Product" && (
                <ItemStock
                    type={type}
                    stockManage={stockManage}
                    stock_hide={stock_hide}
                    isStock={disableBtn}
                />
            )}
        </View>
    );
};

export default ItemDetails;
